/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.parser.DDCCI;
import com.quantumdata.busmon.parser.HDCP;
import com.quantumdata.busmon.parser.I2CMessageType;
import com.quantumdata.busmon.parser.I2CSignal;
import com.quantumdata.busmon.parser.TypeConverter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2CMessage {
    protected I2CMessageType messageType = I2CMessageType.UNKNOWN;
    protected int direction = 0;
    protected boolean isWrite = false;
    protected boolean isFaulty = false;
    protected String whyFaulty;
    protected String explanation = "";
    protected String details = "";
    protected String stateMachineTraversal;
    protected int destination = 0;
    protected int source = 0;
    protected int length = 0;
    protected int command = 0;
    protected int opcode = 0;
    protected int register;
    protected int resultcode = 0;
    protected int typecode = 0;
    protected int maxvalue = 0;
    protected int curvalue = 0;
    public static boolean processingI2CRead = false;
    private static int lastRegister = 0;
    private static int readRegister = 0;

    public I2CMessage() {
    }

    public I2CMessage(Vector<I2CSignal> vector) {
        this();
        ParseState parseState = ParseState.GET_START;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("State Machine Traversal:\n");
        try {
            block34: for (int i = 0; i < vector.size() && parseState != ParseState.ERROR; ++i) {
                int n = vector.get(i).getData() & 0xFF;
                int n2 = vector.get(i).getType();
                stringBuffer3.append(parseState.toString());
                stringBuffer3.append(" -> ");
                if (parseState != ParseState.GET_START && n2 == 1) {
                    this.whyFaulty = "The parser saw an I2C START condition when none was expected.  This should not be possible during normal bus monitor usage, and constitutes a program malfunction.  Please contact Quantum Data.\n";
                    parseState = ParseState.ERROR;
                    break;
                }
                switch (parseState) {
                    case GET_START: {
                        if (n2 != 1) {
                            this.whyFaulty = "The parser did not see an I2C START condition when one was expected.\n";
                            stringBuffer.append("[Missing START]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        this.destination = 0;
                        parseState = ParseState.GET_DESTINATION;
                        continue block34;
                    }
                    case GET_DESTINATION: {
                        this.destination |= n & 0xFE;
                        this.isWrite = (n & 1) == 0;
                        int n3 = this.direction = this.isWrite ? 1 : -1;
                        if (n2 != 2) {
                            this.whyFaulty = "The parser did not see an I2C destination address when one was expected.\n";
                            stringBuffer.append("[Missing Data]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        if ((n & 0xF0) == 240) {
                            this.destination = (n & 6) << 7;
                            parseState = ParseState.GET_DESTINATION;
                            continue block34;
                        }
                        switch (this.destination) {
                            case 96: {
                                this.messageType = I2CMessageType.EDID;
                                stringBuffer.append("E-EDID Segment ");
                                stringBuffer2.append("The master requested an Enhanced EDID Read and set the segment to ");
                                parseState = ParseState.GET_EDID_SEGMENT;
                                continue block34;
                            }
                            case 116: 
                            case 118: {
                                this.messageType = I2CMessageType.HDCP;
                                if (this.isWrite) {
                                    this.register = vector.get(++i).getData() & 0xFF;
                                    if (i == vector.size() - 1) {
                                        stringBuffer.append(String.format("READ %s", HDCP.getShortRegisterName(this.destination, this.register)));
                                        stringBuffer2.append(String.format("The master requested a read of register 0x%02X", this.register));
                                    }
                                    lastRegister = this.register;
                                    readRegister = this.register;
                                    parseState = ParseState.GET_HDCP_WRITE_DATA;
                                    processingI2CRead = true;
                                    continue block34;
                                }
                                if (processingI2CRead) {
                                    this.register = readRegister;
                                    lastRegister = readRegister;
                                    stringBuffer.append(String.format("REPLY %s = ", HDCP.getShortRegisterName(this.destination, this.register)));
                                    stringBuffer2.append("The master read the following data:\n");
                                } else {
                                    stringBuffer.append("SFR REPLY Ri' = ");
                                    stringBuffer2.append("The master requested an HDCP Short Form Read, and read the following data:\n");
                                    this.register = 8;
                                    lastRegister = 8;
                                    readRegister = 8;
                                }
                                parseState = ParseState.GET_HDCP_DATA;
                                continue block34;
                            }
                            case 110: {
                                this.messageType = I2CMessageType.DDCCI;
                                if (this.isWrite) {
                                    stringBuffer.append("Command ");
                                    stringBuffer2.append("The master issued the VCP command ");
                                    parseState = ParseState.GET_VCP_COMMAND;
                                    continue block34;
                                }
                                stringBuffer.append("Reply ");
                                stringBuffer2.append("The master requested the VCP Reply ");
                                parseState = ParseState.GET_VCP_REPLY;
                                continue block34;
                            }
                            case 160: {
                                this.messageType = I2CMessageType.EDID;
                                if (this.isWrite) {
                                    parseState = ParseState.GET_EDID_REQUEST_OFFSET;
                                    continue block34;
                                }
                                stringBuffer.append("Response");
                                stringBuffer2.append("The slave issued a response.\n");
                                parseState = ParseState.IGNORE_REST;
                                continue block34;
                            }
                        }
                        this.messageType = I2CMessageType.UNKNOWN;
                        stringBuffer.append("I2C");
                        stringBuffer.append(this.isWrite ? "W" : "R");
                        stringBuffer2.append("An I2C");
                        stringBuffer2.append(this.isWrite ? " Write" : " Read");
                        if ((this.destination & 0x300) == 0) {
                            stringBuffer.append(String.format(" %02X", this.destination));
                            stringBuffer2.append(" was performed on address");
                            stringBuffer2.append(String.format(" 0x%02X", this.destination));
                        } else {
                            stringBuffer.append(String.format(" %03X", this.destination));
                            stringBuffer2.append(" was performed on 10-bit address");
                            stringBuffer2.append(String.format(" 0x%03X", this.destination));
                        }
                        stringBuffer2.append(".  No further information is available about this message.\n");
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case GET_HDCP_WRITE_DATA: {
                        this.register = lastRegister;
                        if (n2 == 3) {
                            this.whyFaulty = "The parser expected data to write, or an end-of-message, but saw a START condition instead.\n";
                            stringBuffer.append("[Invalid Data]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        this.messageType = I2CMessageType.HDCP;
                        stringBuffer.append(String.format("WRITE %s = ", HDCP.getShortRegisterName(this.destination, this.register)));
                        stringBuffer2.append("The master wrote the following data:\n");
                        parseState = ParseState.GET_HDCP_DATA;
                    }
                    case GET_HDCP_DATA: {
                        this.register = lastRegister++;
                        if (n2 == 2) {
                            this.messageType = I2CMessageType.HDCP;
                            stringBuffer.append(String.format(" %02X", n));
                            stringBuffer2.append(String.format("\tRegister 0x%02X (%s) = 0x%02X\n", this.register, HDCP.getRegisterName(this.destination, this.register), n));
                            parseState = ParseState.GET_HDCP_DATA;
                            continue block34;
                        }
                        i = vector.size();
                        continue block34;
                    }
                    case GET_EDID_SEGMENT: {
                        if (n2 != 2) {
                            this.whyFaulty = "The parser did not see an E-EDID segment address when one was expected.\n";
                            stringBuffer.append("Missing Data");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        stringBuffer.append(String.format("%02d ", n));
                        stringBuffer2.append(String.format("%02d (0x%02x).\n", n, n));
                        parseState = ParseState.GET_EOM;
                        continue block34;
                    }
                    case GET_EDID_REQUEST_OFFSET: {
                        if (n2 != 2) {
                            this.messageType = I2CMessageType.ERROR;
                            this.isFaulty = true;
                            this.whyFaulty = "The parser saw an EDID request with no following EDID offset.\n";
                            stringBuffer.append("Request: [Missing Data]");
                            stringBuffer2.append("\nERROR: ");
                            stringBuffer2.append(this.whyFaulty);
                            this.isFaulty = true;
                            continue block34;
                        }
                        if (n != 0) {
                            stringBuffer.append(String.format("Request @ Ofs %02d", n));
                            stringBuffer2.append(String.format("The master requested EDID data from offset %02d.\n", n));
                        } else {
                            stringBuffer.append("Request @ Last Offset");
                            stringBuffer2.append("The master requested EDID data continuing from the last offset read.\n");
                        }
                        parseState = ParseState.GET_EOM;
                        continue block34;
                    }
                    case GET_VCP_COMMAND: {
                        this.source = vector.get(i).getData();
                        this.length = vector.get(++i).getData() & 0x7F;
                        this.command = vector.get(++i).getData();
                        stringBuffer.append(DDCCI.getCommandName(this.command));
                        stringBuffer.append(": ");
                        stringBuffer2.append(DDCCI.getCommandName(this.command));
                        stringBuffer2.append("\n");
                        switch (this.command) {
                            case 1: {
                                this.opcode = vector.get(++i).getData();
                                stringBuffer.append(DDCCI.getShortOpcodeName(this.opcode));
                                stringBuffer2.append("Opcode ");
                                stringBuffer2.append(DDCCI.getOpcodeName(this.opcode));
                                parseState = ParseState.GET_VCP_CHECKSUM;
                                continue block34;
                            }
                            case 2: {
                                this.whyFaulty = "This message type cannot be issued by a host device.\n";
                                stringBuffer.append("[Invalid Issuer]");
                                parseState = ParseState.ERROR;
                                continue block34;
                            }
                        }
                        stringBuffer.append(String.format("0x%02X (unknown)", this.command));
                        stringBuffer2.append(String.format(": Unknown message type 0x%02X\nThe parser does not recognize this message type.\n", this.command));
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case GET_VCP_REPLY: {
                        this.source = vector.get(i).getData();
                        this.length = vector.get(++i).getData() & 0x7F;
                        this.command = vector.get(++i).getData();
                        stringBuffer.append(DDCCI.getCommandName(this.command));
                        stringBuffer2.append(DDCCI.getCommandName(this.command));
                        switch (this.command) {
                            case 1: {
                                this.whyFaulty = "This message type cannot be issued by a display device.\n";
                                stringBuffer.append("Invalid Issuer");
                                parseState = ParseState.ERROR;
                                continue block34;
                            }
                            case 2: {
                                this.resultcode = vector.get(++i).getData();
                                this.opcode = vector.get(++i).getData();
                                this.typecode = vector.get(++i).getData();
                                this.maxvalue = TypeConverter.composeIntFromSignals(vector, ++i);
                                ++i;
                                this.curvalue = TypeConverter.composeIntFromSignals(vector, ++i);
                                ++i;
                                stringBuffer.append(String.format("%s = ", DDCCI.getShortOpcodeName(this.opcode)));
                                stringBuffer2.append(String.format("Opcode %s = ", DDCCI.getOpcodeName(this.opcode)));
                                if (this.resultcode == 1) {
                                    stringBuffer.append("(Unsup)");
                                    stringBuffer2.append("(Unsupported VCP Code)");
                                } else {
                                    stringBuffer.append(DDCCI.getArgumentString(this.opcode, this.curvalue));
                                    stringBuffer2.append(DDCCI.getArgumentString(this.opcode, this.curvalue));
                                }
                                parseState = ParseState.GET_VCP_CHECKSUM;
                                continue block34;
                            }
                        }
                        stringBuffer.append(String.format("0x%02X (unknown)", this.command));
                        stringBuffer2.append(String.format(": Unknown message type 0x%02X\nThe parser does not recognize this message type.\n", this.command));
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case GET_VCP_CHECKSUM: {
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case IGNORE_REST: {
                        if (n2 != 3) continue block34;
                        i = vector.size();
                        continue block34;
                    }
                    case GET_EOM: {
                        if (n2 == 2) {
                            this.whyFaulty = "The parser saw extra data when it was expecting a START condition.\n";
                            stringBuffer.append("[Extraneous Data]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        this.whyFaulty = "An I2C STOP at this point is not supported by VESA E-DDC Spec v1.1.  A REPEATED START is expected.\n";
                        stringBuffer.append("[Unexpected STOP]");
                        parseState = ParseState.ERROR;
                        continue block34;
                    }
                    case GET_STOP: {
                        if (n2 == 3) {
                            i = vector.size();
                            continue block34;
                        }
                        this.whyFaulty = "The parser did not see an expected STOP signal.\n";
                        stringBuffer.append("[Missing STOP]");
                        parseState = ParseState.ERROR;
                        continue block34;
                    }
                    default: {
                        stringBuffer.append("(?");
                        stringBuffer.append(parseState.toString());
                        stringBuffer.append("?):");
                        stringBuffer2.append("\nPROGRAM ERROR: Parser in unimplemented state ");
                        stringBuffer2.append(parseState.toString());
                        stringBuffer2.append("\n");
                        parseState = ParseState.IGNORE_REST;
                    }
                }
            }
            switch (parseState) {
                case GET_EDID_SEGMENT: 
                case GET_EDID_REQUEST_OFFSET: 
                case GET_VCP_COMMAND: 
                case GET_VCP_REPLY: 
                case GET_VCP_CHECKSUM: {
                    this.messageType = I2CMessageType.ERROR;
                    this.isFaulty = true;
                    stringBuffer.append(":EOP");
                    stringBuffer2.append("\nERROR: ");
                    stringBuffer2.append("Unexpected end of packet.\n");
                }
                case ERROR: {
                    this.messageType = I2CMessageType.ERROR;
                    this.isFaulty = true;
                    stringBuffer2.append("\nERROR: ");
                    stringBuffer2.append(this.whyFaulty);
                    break;
                }
            }
            stringBuffer2.append("\nEnd of parsing.\n");
            this.explanation = stringBuffer.toString();
            this.details = stringBuffer2.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.messageType = I2CMessageType.ERROR;
            this.isFaulty = true;
            this.whyFaulty = "Unexpected end of packet.\n";
            stringBuffer.append(":EOP");
            stringBuffer2.append("\nERROR: ");
            stringBuffer2.append(this.whyFaulty);
            this.explanation = stringBuffer.toString();
            this.details = stringBuffer2.toString();
        }
        stringBuffer3.append("(END)\n");
        this.stateMachineTraversal = stringBuffer3.toString();
    }

    public I2CMessageType getMessageType() {
        return this.messageType;
    }

    public String getType() {
        switch (this.messageType) {
            case DDCCI: {
                return "DDC/CI";
            }
            case EDID: {
                return "EDID";
            }
            case HDCP: {
                return "HDCP";
            }
            case ERROR: {
                return "BAD I2C";
            }
            case EMPTY: {
                return "Empty I2C";
            }
        }
        return "Other I2C";
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getDetails() {
        if (MainAppFrame.toggleStateTraceAction.isTrue()) {
            return this.details + "\n\n" + this.stateMachineTraversal;
        }
        return this.details;
    }

    public String getDirection() {
        return this.direction > 0 ? "MSTR -> SLAVE" : (this.direction < 0 ? "SLAVE -> MSTR" : "(n/a)");
    }

    public int getVCPCommand() {
        return this.command;
    }

    public int getVCPOpcode() {
        return this.opcode;
    }

    public int getHDCPRegister() {
        return this.register;
    }

    public String getStateMachineTraversal() {
        return this.stateMachineTraversal;
    }

    public boolean isError() {
        return this.isFaulty;
    }

    public String whyError() {
        return this.whyFaulty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseState {
        PARSE_BEGIN,
        GET_START,
        GET_DESTINATION,
        GET_EDID_SEGMENT,
        GET_EDID_REQUEST_OFFSET,
        GET_HDCP_REGISTER,
        GET_HDCP_WRITE_DATA,
        GET_HDCP_DATA,
        GET_VCP_COMMAND,
        GET_VCP_REPLY,
        GET_VCP_CHECKSUM,
        GET_DATA,
        GET_STOP,
        GET_EOM,
        IGNORE_REST,
        ERROR;

    }
}

